<?php
/**
 * ColorMag svg icons class
 *
 * @package ColorMag
 *
 * TODO: @since.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'ColorMag_SVG_Icons' ) ) {

	/**
	 * ColorMag_SVG_Icons class.
	 */
	class ColorMag_SVG_Icons {

		/**
		 * Allowed HTML.
		 *
		 * @var bool[][]
		 */
		public static $allowed_html = array(
			'svg'     => array(
				'class'       => true,
				'xmlns'       => true,
				'width'       => true,
				'height'      => true,
				'viewbox'     => true,
				'aria-hidden' => true,
				'role'        => true,
				'focusable'   => true,
			),
			'path'    => array(
				'fill'      => true,
				'fill-rule' => true,
				'd'         => true,
				'transform' => true,
			),
			'circle'  => array(
				'cx' => true,
				'cy' => true,
				'r'  => true,
			),
			'polygon' => array(
				'fill'      => true,
				'fill-rule' => true,
				'points'    => true,
				'transform' => true,
				'focusable' => true,
			),
		);

		/**
		 * SVG icons.
		 *
		 * @var string[]
		 */
		public static $icons = array(
			'calendar-fill'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21.1 6.6v1.6c0 .6-.4 1-1 1H3.9c-.6 0-1-.4-1-1V6.6c0-1.5 1.3-2.8 2.8-2.8h1.7V3c0-.6.4-1 1-1s1 .4 1 1v.8h5.2V3c0-.6.4-1 1-1s1 .4 1 1v.8h1.7c1.5 0 2.8 1.3 2.8 2.8zm-1 4.6H3.9c-.6 0-1 .4-1 1v7c0 1.5 1.3 2.8 2.8 2.8h12.6c1.5 0 2.8-1.3 2.8-2.8v-7c0-.6-.4-1-1-1z"></path></svg>',
			'comment'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M22 5v10c0 1.7-1.3 3-3 3H7.4l-3.7 3.7c-.2.2-.4.3-.7.3-.1 0-.3 0-.4-.1-.4-.1-.6-.5-.6-.9V5c0-1.7 1.3-3 3-3h14c1.7 0 3 1.3 3 3z"></path></svg>',
			'eye'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21.9 11.6c-.2-.2-3.6-7-9.9-7s-9.8 6.7-9.9 7c-.1.3-.1.6 0 .9.2.2 3.7 7 9.9 7s9.7-6.8 9.9-7c.1-.3.1-.6 0-.9zM12 15.5c-2 0-3.5-1.5-3.5-3.5S10 8.5 12 8.5s3.5 1.5 3.5 3.5-1.5 3.5-3.5 3.5z"></path></svg>',
			'heart-fill'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20.32 4.83a5.73 5.73 0 0 0-8.11 0L12 5l-.21-.21a5.73 5.73 0 0 0-8.11 8.11l7.61 7.62a1 1 0 0 0 1.42 0l7.61-7.62a5.73 5.73 0 0 0 0-8.07Z"></path></svg>',
			'user'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M7 7c0-2.8 2.2-5 5-5s5 2.2 5 5-2.2 5-5 5-5-2.2-5-5zm9 7H8c-2.8 0-5 2.2-5 5v2c0 .6.4 1 1 1h16c.6 0 1-.4 1-1v-2c0-2.8-2.2-5-5-5z"></path></svg>',
			'edit'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M17.31 22H4.79A2.79 2.79 0 0 1 2 19.21V6.69A2.79 2.79 0 0 1 4.79 3.9h6.26a1 1 0 0 1 0 2H4.79a.79.79 0 0 0-.79.79v12.52a.79.79 0 0 0 .79.79h12.52a.79.79 0 0 0 .79-.79V13a1 1 0 1 1 2 0v6.26A2.79 2.79 0 0 1 17.31 22Zm-8.7-5.4 3.58-.89a1.17 1.17 0 0 0 .46-.26L21.15 7a2.9 2.9 0 1 0-4.1-4.1l-8.49 8.5a1.08 1.08 0 0 0-.27.46l-.89 3.53a1 1 0 0 0 .26.95 1 1 0 0 0 .71.29 1 1 0 0 0 .24-.03Zm9.86-12.34A.9.9 0 0 1 20 4.9a.88.88 0 0 1-.26.63l-8.31 8.3-1.69.43.43-1.69Z"></path></svg>',
			'tag'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m21.2 10.4-8.1-8.1c-.2-.2-.4-.3-.7-.3H3c-.6 0-1 .5-1 1v9.4c0 .3.1.5.3.7l8.1 8.1c.5.5 1.3.8 2 .8.8 0 1.5-.3 2-.8l6.7-6.7c1.2-1.2 1.2-3 .1-4.1zM7.7 8.7c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z"></path></svg>',
			'home'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 22"><path d="M13.6465 6.01133L5.11148 13.0409V20.6278C5.11148 20.8242 5.18952 21.0126 5.32842 21.1515C5.46733 21.2904 5.65572 21.3685 5.85217 21.3685L11.0397 21.3551C11.2355 21.3541 11.423 21.2756 11.5611 21.1368C11.6992 20.998 11.7767 20.8102 11.7767 20.6144V16.1837C11.7767 15.9873 11.8547 15.7989 11.9937 15.66C12.1326 15.521 12.321 15.443 12.5174 15.443H15.4801C15.6766 15.443 15.865 15.521 16.0039 15.66C16.1428 15.7989 16.2208 15.9873 16.2208 16.1837V20.6111C16.2205 20.7086 16.2394 20.8052 16.2765 20.8953C16.3136 20.9854 16.3681 21.0673 16.4369 21.1364C16.5057 21.2054 16.5875 21.2602 16.6775 21.2975C16.7675 21.3349 16.864 21.3541 16.9615 21.3541L22.1472 21.3685C22.3436 21.3685 22.532 21.2904 22.6709 21.1515C22.8099 21.0126 22.8879 20.8242 22.8879 20.6278V13.0358L14.3548 6.01133C14.2544 5.93047 14.1295 5.88637 14.0006 5.88637C13.8718 5.88637 13.7468 5.93047 13.6465 6.01133ZM27.1283 10.7892L23.2582 7.59917V1.18717C23.2582 1.03983 23.1997 0.898538 23.0955 0.794359C22.9913 0.69018 22.8501 0.631653 22.7027 0.631653H20.1103C19.963 0.631653 19.8217 0.69018 19.7175 0.794359C19.6133 0.898538 19.5548 1.03983 19.5548 1.18717V4.54848L15.4102 1.13856C15.0125 0.811259 14.5134 0.632307 13.9983 0.632307C13.4832 0.632307 12.9841 0.811259 12.5864 1.13856L0.868291 10.7892C0.81204 10.8357 0.765501 10.8928 0.731333 10.9573C0.697165 11.0218 0.676038 11.0924 0.66916 11.165C0.662282 11.2377 0.669786 11.311 0.691245 11.3807C0.712704 11.4505 0.747696 11.5153 0.794223 11.5715L1.97469 13.0066C2.02109 13.063 2.07816 13.1098 2.14264 13.1441C2.20711 13.1784 2.27773 13.1997 2.35044 13.2067C2.42315 13.2137 2.49653 13.2063 2.56638 13.1849C2.63623 13.1636 2.70118 13.1286 2.7575 13.0821L13.6465 4.11333C13.7468 4.03247 13.8718 3.98837 14.0006 3.98837C14.1295 3.98837 14.2544 4.03247 14.3548 4.11333L25.2442 13.0821C25.3004 13.1286 25.3653 13.1636 25.435 13.1851C25.5048 13.2065 25.5781 13.214 25.6507 13.2071C25.7234 13.2003 25.794 13.1791 25.8584 13.145C25.9229 13.1108 25.98 13.0643 26.0265 13.008L27.207 11.5729C27.2535 11.5164 27.2883 11.4512 27.3095 11.3812C27.3307 11.3111 27.3379 11.2375 27.3306 11.1647C27.3233 11.0919 27.3016 11.0212 27.2669 10.9568C27.2322 10.8923 27.1851 10.8354 27.1283 10.7892Z" /></svg>',
			'arrow-left'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21 11H5.41l7.3-7.29a1 1 0 1 0-1.42-1.42l-9 9a.93.93 0 0 0-.21.33A1 1 0 0 0 2 12a1.09 1.09 0 0 0 .08.39 1.06 1.06 0 0 0 .21.31l9 9a1 1 0 0 0 1.42 0 1 1 0 0 0 0-1.42L5.41 13H21a1 1 0 0 0 0-2Z"></path></svg>',
			'arrow-right'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 11h15.59l-7.3-7.29a1 1 0 0 1 1.42-1.42l9 9a.93.93 0 0 1 .21.33A1 1 0 0 1 22 12a1.09 1.09 0 0 1-.08.39 1.06 1.06 0 0 1-.21.31l-9 9a1 1 0 0 1-1.42 0 1 1 0 0 1 0-1.42l7.3-7.28H3a1 1 0 0 1 0-2Z"></path></svg>',
			'arrow-left-long'  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M2 12.38a1 1 0 0 1 0-.76.91.91 0 0 1 .22-.33L6.52 7a1 1 0 0 1 1.42 0 1 1 0 0 1 0 1.41L5.36 11H21a1 1 0 0 1 0 2H5.36l2.58 2.58a1 1 0 0 1 0 1.41 1 1 0 0 1-.71.3 1 1 0 0 1-.71-.3l-4.28-4.28a.91.91 0 0 1-.24-.33Z"></path></svg>',
			'arrow-right-long' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21.92 12.38a1 1 0 0 0 0-.76 1 1 0 0 0-.21-.33L17.42 7A1 1 0 0 0 16 8.42L18.59 11H2.94a1 1 0 1 0 0 2h15.65L16 15.58A1 1 0 0 0 16 17a1 1 0 0 0 1.41 0l4.29-4.28a1 1 0 0 0 .22-.34Z"></path></svg>',
			'bars'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21 19H3a1 1 0 0 1 0-2h18a1 1 0 0 1 0 2Zm0-6H3a1 1 0 0 1 0-2h18a1 1 0 0 1 0 2Zm0-6H3a1 1 0 0 1 0-2h18a1 1 0 0 1 0 2Z"></path></svg>',
			'x-mark'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m13.4 12 8.3-8.3c.4-.4.4-1 0-1.4s-1-.4-1.4 0L12 10.6 3.7 2.3c-.4-.4-1-.4-1.4 0s-.4 1 0 1.4l8.3 8.3-8.3 8.3c-.4.4-.4 1 0 1.4.2.2.4.3.7.3s.5-.1.7-.3l8.3-8.3 8.3 8.3c.2.2.5.3.7.3s.5-.1.7-.3c.4-.4.4-1 0-1.4L13.4 12z"></path></svg>',
			'random-fill'      => '<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 24 24"><path d="M21.73 16a1 1 0 0 1 0 1.33l-3.13 3.14a.94.94 0 0 1-1.6-.66v-1.56h-2.3a.39.39 0 0 1-.18 0 .36.36 0 0 1-.16-.11l-2.76-3 2.09-2.23 2.06 2.21H17v-1.56a.94.94 0 0 1 1.6-.66ZM2.47 8.88h3.28l2.06 2.2L9.9 8.85 7.14 5.9A.36.36 0 0 0 7 5.79a.39.39 0 0 0-.18 0H2.47a.47.47 0 0 0-.47.43v2.19a.47.47 0 0 0 .47.47Zm14.53 0v1.56a.94.94 0 0 0 1.6.66L21.73 8a1 1 0 0 0 0-1.33L18.6 3.53a.94.94 0 0 0-1.6.66v1.56h-2.3a.39.39 0 0 0-.18 0 .36.36 0 0 0-.16.11l-8.61 9.27H2.47a.46.46 0 0 0-.47.46v2.19a.47.47 0 0 0 .47.47H6.8a.45.45 0 0 0 .34-.15l8.61-9.22Z"></path></svg>',
			'permalink'        => '<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 24 24"><path d="M16.48 21.91a5.45 5.45 0 0 0 3.91-9.22L17.66 10a7.19 7.19 0 0 0-.59-.51 5.45 5.45 0 0 0-7.61 1.1.91.91 0 1 0 1.45 1.09 3.62 3.62 0 0 1 5.09-.77 3.14 3.14 0 0 1 .4.34L19.09 14a3.57 3.57 0 0 1 1 2.57A3.63 3.63 0 0 1 14 19.08l-1.54-1.54a.89.89 0 0 0-1.28 0 .91.91 0 0 0 0 1.28l1.55 1.55a5.43 5.43 0 0 0 3.75 1.54Zm-6.3-6.28a5.46 5.46 0 0 0 4.36-2.18.92.92 0 0 0-.19-1.27.91.91 0 0 0-1.27.18 3.62 3.62 0 0 1-5.08.73 2.5 2.5 0 0 1-.39-.34L4.9 10A3.63 3.63 0 0 1 10 4.92l1.55 1.54a.9.9 0 1 0 1.27-1.28L11.3 3.63a5.43 5.43 0 0 0-7.69 7.68L6.34 14a5.48 5.48 0 0 0 3.84 1.59Z"></path></svg>',
		);

		/**
		 * Get the SVG icon.
		 *
		 * @param string $icon Default is empty.
		 * @param bool   $echo Default is true.
		 * @param array  $args Default is empty.
		 *
		 * @return string|null
		 */
		public static function get_svg( $icon = '', $echo = true, $args = array() ) {

			$icons = self::get_icons();
			$atts  = '';
			$svg   = '';

			if ( ! empty( $args ) ) {

				foreach ( $args as $key => $value ) {

					if ( ! empty( $value ) ) {

						$atts .= esc_html( $key ) . '="' . esc_attr( $value ) . '" ';
					}
				}
			}

			if ( array_key_exists( $icon, $icons ) ) {

				$repl = sprintf( '<svg class="cm-icon cm-icon--%1$s" %2$s', $icon, $atts );
				$svg  = preg_replace( '/^<svg /', $repl, trim( $icons[ $icon ] ) );
				$svg  = preg_replace( "/([\n\t]+)/", ' ', $svg );
				$svg  = preg_replace( '/>\s*</', '><', $svg );
			}

			if ( ! $svg ) {

				return null;
			}

			if ( $echo ) {

				echo wp_kses( $svg, self::$allowed_html );
			} else {

				return wp_kses( $svg, self::$allowed_html );
			}
		}

		/**
		 * Get all SVG icons.
		 *
		 * @return mixed|void
		 */
		public static function get_icons() {

			/**
			 * Filter for svg icons.
			 *
			 * TODO: @since.
			 */
			return apply_filters( 'coloramg_svg_icons', self::$icons );
		}
	}
}
