<?php
/**
 * Extend WP_Customize_Control to add dropdown categories control.
 *
 * Class ColorMag_Dropdown_Categories_Control
 *
 * @package    ThemeGrill
 * @subpackage ColorMag
 * @since      ColorMag 3.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class to extend WP_Customize_Control to add dropdown categories customize control.
 *
 * Class ColorMag_Dropdown_Categories_Control
 */
class ColorMag_Dropdown_Categories_Control extends ColorMag_Customize_Base_Additional_Control {

	/**
	 * Control's Type.
	 *
	 * @var string
	 */
	public $type = 'colormag-dropdown-categories';

	/**
	 * Dropdown categories array for this control.
	 *
	 * @var array
	 */
	public $dropdown = array();

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @see WP_Customize_Control::to_json()
	 */
	public function to_json() {

		parent::to_json();

		$this->json['default'] = $this->setting->default;
		if ( isset( $this->default ) ) {
			$this->json['default'] = $this->default;
		}
		$this->json['value'] = $this->value();

		$this->json['link']        = $this->get_link();
		$this->json['id']          = $this->id;
		$this->json['label']       = esc_html( $this->label );
		$this->json['description'] = $this->description;

		$dropdown = wp_dropdown_categories(
			array(
				'echo'              => false,
				'name'              => '_customize-dropdown-categories-' . esc_attr( $this->id ),
				'show_option_none'  => ' ',
				'option_none_value' => '-1',
				'selected'          => esc_attr( $this->value() ),
			)
		);

		// Add in the data link parameter for dropdown categories.
		$dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );

		$this->json['dropdown'] = $dropdown;

		$this->json['inputAttrs'] = '';
		foreach ( $this->input_attrs as $attr => $value ) {
			$this->json['inputAttrs'] .= $attr . '="' . esc_attr( $value ) . '" ';
		}

	}

	/**
	 * An Underscore (JS) template for this control's content (but not its container).
	 *
	 * Class variables for this control class are available in the `data` JS object;
	 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.
	 *
	 * @see WP_Customize_Control::print_template()
	 */
	protected function content_template() {
		?>

		<div class="customizer-text">
			<# if ( data.label ) { #>
			<span class="customize-control-label">{{{ data.label }}}</span>
			<# } #>

			<# if ( data.description ) { #>
			<span class="description customize-control-description">{{{ data.description }}}</span>
			<# } #>
		</div>

		<div class="customize-control-content">
			{{{ data.dropdown }}}
		</div>

		<?php
	}

	/**
	 * Don't render the control content from PHP, as it's rendered via JS on load.
	 */
	public function render_content() {
	}

}
